#!/usr/bin/python3
# coding: utf-8

#################################################################
#
# Copyright (C) ИП Пуляев Григорий Васильевич, 2024
# email: rodegast@xmail.ru
# telegram: t.me/kybyc_meta_test
#
# Расширение добавляет поддержку браузера Safari
# в плплатформуатфому автоматизированного тестирования Meta Test.
#
# Этот файл НЕ является частью платформы Meta Test.
# Лицензия расширения - Apache License 2.0
# https://www.apache.org/licenses/LICENSE-2.0
#
#################################################################

from functools import lru_cache

from selenium import webdriver

from utilites import get_platform
from core_brower import WebBrowser
from parameter import CONFIG, LOG_LEVEL

# https://developer.apple.com/documentation/webkit/testing_with_webdriver_in_safari
# safaridriver --enable

class Safari(WebBrowser):
	@staticmethod
	def system_support():
		"""
		Возвращает True если браузер совместим с текущей системой
		"""
		return get_platform() == "mac-x64"
	
	@lru_cache
	def installed_versions(self):
		"""
		Возвращает описание локально установленных браузерах
		{"версия браузера": "путь к исполняемому файлу"}
		"""
		return self.mac_installed_version("/Applications/Safari.app")
	
	def make_options(self):
		"""
		Возвращает объект конфигурации драйвера
		"""
		options = webdriver.SafariOptions()
		#options.automatic_profiling    = True
		#options.automatic_inspection   = True
		#options.use_technology_preview = True
		return options
	
	def make_service(self):
		"""
		Возвращает объект обслуживания
		"""
		args = {"executable_path": self.binary_location}
		if not CONFIG.LOG_LEVEL == LOG_LEVEL.OFF:
			args["service_args"] = ["--diagnose"]
		return webdriver.SafariService(**args)
	
	@property
	def web_driver_class(self):
		"""
		Возвращает класс веб-драйвера
		"""
		return webdriver.Safari
	
	@property
	def browser_name(self):
		"""
		Возвращает имя браузера
		"""
		return "safari"
	
	@property
	def binary_location(self):
		"""
		Путь к исполняемому файлу браузера указанный пользователем
		"""
		return "/usr/bin/safaridriver"
	
	@property
	def driver_path(self):
		"""
		Возвращает путь к файлу драйвера
		"""
		return "/usr/bin/safaridriver"
