from typing import Union
from types import NoneType

from selenium.webdriver.common.service import Service
from selenium.webdriver.common.options import ArgOptions
from selenium.webdriver.remote.webdriver import BaseWebDriver

from core_server import BaseServer

def install(url: str, install_path: str, install_files: Union[NoneType, list[str]]):
	"""
	Загружает файл (zip или tar) с адреса URL и распаковывает его в каталог install_path
	install_files - список файлов которые нужно установить
	"""

class BaseBrowser:
	"""
	Базовый класс броузеров
	"""
	@staticmethod
	def system_suport() -> bool:
		pass
	
	def installed_versions(self) -> dict:
		"""
		Возвращает описание локально установленных браузеров
		{"версия броузера": "путь к исполняемому файлу"}
		"""
	
	def linux_installed_version(self, bin_names_list: list[str]) -> dict:
		"""
		Возвращает описание локально установленных браузеров для платформы linux_64
		"""
	
	def mac_installed_version(self, app_path: str) -> dict:
		"""
		Возвращает описание локально установленных браузеров для платформы mac-x64
		"""
	
	def windows_installed_version(self, exe_path_list: list[str]) -> dict:
		"""
		Возвращает описание локально установленных браузеров для платформы win
		exe_path_list - список путей к проверяемым файлам
		"""
	
	def install_browser(self) -> str:
		"""
		Скачиваем и устанавливает браузер, возвращает путь к исполняемому файлу
		"""
	
	def linux_install_browser(self, install_path: str) -> str:
		"""
		Скачиваем и устанавливает браузер для linux. Возвращает путь к исполняемому файлу
		"""
	
	def mac_install_browser(self, install_path: str) -> str:
		"""
		Скачиваем и устанавливает браузер для mac-64. Возвращает путь к исполняемому файлу
		"""
	
	def windows_install_browser(self, install_path: str) -> str:
		"""
		Скачиваем и устанавливает браузер для windows. Возвращает путь к исполняемому файлу
		"""
	
	def available_versions(self) -> list[str]:
		"""
		Возвращает список версий браузеров которые возможно установить
		"""
	
	def get_driver(self) -> BaseWebDriver:
		"""
		Возвращает класс драйвера
		"""
	
	def login(self):
		"""
		Авторизацию. (базовая авторизация и прочее)
		"""
	
	def logout(self):
		"""
		Выход при использовании авторизации
		"""
	
	def vacuum(self):
		"""
		Метод очистки браузера. Вызывается если установлен режим VACUUM
		"""
	
	def del_download(self):
		"""
		Удаление скаченных файлов
		"""
	
	def get_download_file(self, name: str) -> str:
		"""
		Возвращает путь к скаченному файлу, если файла нет, то ошибка FileNotFoundError
		"""
	
	def get_logs(self):
		"""
		Возвращает словарь журналов в формате: {LOG_TYPES: "log"}
		"""
	
	def quit(self):
		"""
		Закрытие сессии
		"""
	
	def make_options(self) -> ArgOptions:
		"""
		Возвращает объект конфигурации драйвера
		"""
	
	def make_service(self) -> Service:
		"""
		Возвращает объект обслуживания
		"""
	
	def set_binary_location(self, path: str):
		"""
		Устанавливает путь к исполняемому файлу браузера
		"""
	
	def extensions(self) -> list[str]:
		"""
		Возвращает список путей к файлам расширения браузера
		"""
	
	@property
	def server(self) -> BaseServer:
		"""
		Возвращает объект сервера
		"""
	
	@property
	def web_driver_class(self) -> BaseWebDriver:
		"""
		Возвращает класс веб-драйвера
		"""
	
	@property
	def uuid(self) -> str:
		"""
		Идентификатор текущего экземпляра браузера
		"""
	
	@property
	def is_local_browser(self) -> bool:
		"""
		Возвращает True если используется локально установленный броузер
		"""
	
	@property
	def enable_logs(self) -> bool:
		"""
		Возвращает True если поддерживается логирование
		"""
	
	@property
	def browser_name(self) -> str:
		"""
		Возвращает имя броузера
		"""
	
	@property
	def user_version(self) -> str:
		"""
		Возвращает версию броузера которую указал пользователь в качестве используемой
		"""
	
	@property
	def user_local_path(self) -> str:
		"""
		Путь к исполняемому файлу браузера указанный пользователем
		"""
	
	@property
	def binary_location(self) -> str:
		"""
		Путь к исполняемому файлу броузера
		"""
	
	@property
	def driver_path(self) -> str:
		"""
		Возвращает путь к файлу драйвера
		"""
	
	@property
	def session_id(self) -> str:
		"""
		Возвращает идентификатор сессии
		"""
	
	@property
	def version(self) -> str:
		"""
		Возвращает версию броузера которая используется системой
		"""
	
	@property
	def short_version(self) -> str:
		"""
		Возвращает сокращённую версию броузера
		"""
	
	@property
	def major_version(self) -> str:
		"""
		Возвращает старшую часть версии браузера
		"""
	
	@property
	def download_dir(self) -> str:
		"""
		Каталог для загрузки файлов
		"""
	
	@property
	def cache_dir(self) -> str:
		"""
		Каталог для загрузки файлов
		"""
	
	@property
	def profile_dir(self) -> str:
		"""
		Каталог профиля браузеров
		"""
