from functools import lru_cache

class BaseServer:
	"""
	Базовый класс для инфраструктуры
	"""
	def __init__(self, executor: str, browser_name: str):
		pass
	
	def is_match(self) -> bool:
		"""
		Возвращает True если текущий объект подходит для работы с указанным сервером
		"""
	
	def set_session_id(self, session_id: str):
		"""
		Устанавливает идентификатор сессии
		"""
	
	def get_file_detector(self):
		pass
	
	def capability(self) -> (str, dict):
		"""
		Возвращает опции удалённого сервера - ("идентификатор", словась_опций)
		"""
	
	@lru_cache
	def get_remote_versions(self) -> list[str]:
		"""
		Возвращает список удалённых версий браузеров
		"""
	
	@lru_cache
	def server_version(self) -> str:
		"""
		Возвращает версию сервера
		"""
	
	def get_download_file(self, name: str, download_dir: str) -> str:
		"""
		Дожидается завершения скачивания файла.
		Сохраняет скаченный файл в локальный каталог и возвращает путь к скаченному файлу.
		Если файла нет, то ошибка FileNotFoundError
		"""
	
	def get_size_download_file(self, name: str) -> int:
		"""
		Дожидается завершения скачивания файла и возвращает его размер
		Если файла нет, то ошибка FileNotFoundError
		"""
	
	def del_download_file(self, name: str):
		"""
		Удаляет скаченный файл на сервере
		"""
	
	def download_files(self) -> list[str]:
		"""
		Возвращает список скаченных файлов
		"""
	
	def get_links(self) -> dict:
		"""
		Возвращает словарь ссылок на файлы видео и логов
		"""
	
	def quit(self):
		"""
		Выполняется после закрытия браузера
		"""
	
	@property
	def quota(self) -> (int, int):
		"""
		Возвращает пару - (максимальное количество сессий, количество запущенных сессий)
		"""
	
	@property
	def session_id(self) -> str:
		"""
		Идентификатор текущей сессии
		"""
	
	@property
	def executor_url(self) -> str:
		"""
		Возвращает URL подключения
		"""
	
	@property
	def executor(self) -> str:
		"""
		Возвращает строку подключения
		"""
	
	@property
	def browser_name(self) -> str:
		"""
		Возвращает идентификатор браузера
		"""
