
class ReportData:
	"""
	Данные для отчётов
	"""
	@property
	def is_parent(self) -> bool:
		"""
		Является субтестом или субстепом
		"""
	
	@property
	def parent_uuid(self) -> str:
		"""
		Возвращает идентификатор родительского объекта
		"""
	
	@property
	def attempt(self) -> int:
		"""
		Количество перезапусков
		"""
	
	@property
	def repeated(self) -> int:
		"""
		Количество последовательных запусков
		"""
	
	@property
	def action_name(self) -> str:
		"""
		Наименование действия
		"""
	
	@property
	def status(self) -> str:
		"""
		Статус текущего действия/шага
		"""
	
	@property
	def value(self) :
		"""
		Значение возвращенное действием
		"""
	
	@property
	def debug(self) -> tuple[(str, str)]:
		"""
		информация для отладки текущего действия
		"""
	
	@property
	def thread_id(self) -> str:
		"""
		Возвращает id потока в котором запущен тест
		"""
	
	@property
	def timestamp(self) -> float:
		"""
		Время запуска
		"""
	
	@property
	def time(self) -> float:
		"""
		Время выполнения действия
		"""
	
	@property
	def url(self) -> str:
		"""
		Адрес текущей страницы
		"""
	
	@property
	def browser_name(self) -> str:
		"""
		Имя браузера
		"""
	
	@property
	def browser_version(self) -> str:
		"""
		Версия броузера
		"""
	
	@property
	def step_title(self) -> str:
		"""
		Заголовок шага
		"""
	
	@property
	def step_uuid(self) -> str:
		"""
		Идентификатор шага
		"""
	
	@property
	def step_args(self) -> dict:
		"""
		Аргументы шага
		"""
	
	@property
	def step_parent_uuid(self) -> str:
		"""
		Возвращает идентификатор родительского шага
		"""
	
	@property
	def step_time(self) -> float:
		"""
		Время выполнения текущего шага
		"""
	
	@property
	def script(self) -> str:
		"""
		Идентификатор текущего скрипта
		"""
	
	@property
	def script_args(self) -> dict:
		"""
		Аргументы текущего скрипта
		"""
	
	@property
	def test_name(self) -> str:
		"""
		Наименование теста
		"""
	
	@property
	def test_title(self) -> str:
		"""
		Заголовок теста
		"""
	
	@property
	def test_uuid(self) -> str:
		"""
		Идентификатор теста
		"""
	
	@property
	def test_args(self) -> dict:
		"""
		Аргументы теста
		"""
	
	@property
	def test_status(self) -> str:
		"""
		Возвращает статус для теста
		"""
	
	@property
	def test_parameters(self) -> dict:
		"""
		Возвращает параметры с которыми был запущен тест
		"""
	
	@property
	def retries(self) -> int:
		"""
		Возвращает максимальное количество перезапусков
		"""
	
	@property
	def file_line(self) -> str:
		"""
		Имя файла с исходным кодом теста и номер строки для текущего действия
		"""
	
	@property
	def arguments(self) -> (tuple, dict):
		"""
		Возвращает позиционные и именованные аргументы для текущего действия
		"""
	
	@property
	def logs(self) -> dict:
		"""
		Возвращает логи селениума
		"""
	
	@property
	def message(self) -> str:
		"""
		Текст сообщений
		"""
	
	@property
	def description(self) -> str:
		"""
		Описание теста или шага
		"""
	
	@property
	def warning(self) -> str:
		"""
		Текст предупреждений
		"""
	
	@property
	def screenshot(self) -> (bytes, bytes):
		"""
		Скриншот окна броузера
		"""
	
	@property
	def device(self) -> (str, str, str):
		"""
		Возвращает тройку (платформа, устройство, имя_устройства)
		Пример: ("android", "pixel ...", "mobile")
		"""
	
	@property
	def page_name(self) -> str:
		"""
		Заголовок страницы
		"""
	
	@property
	def page_source(self) -> str:
		"""
		Исходник страницы
		"""
