#!/usr/bin/python3
# coding: utf-8

#################################################################
#
# Copyright (C) 2024 Пуляев Григорий
# email: rodegast@xmail.ru
# telegram: t.me/kybyc_meta_test
#
# Платформа автоматизированного тестирования Meta Test
# Распространяется на условиях EULA - https://meta_test.kybyc.xyz/license
#
#################################################################

import os
import sys
import traceback

mt_dir = os.path.dirname(__file__)
if not mt_dir in sys.path:
	sys.path.insert(0, mt_dir)

from parameter import TEST_STATUS
from loader import start, test_loader

if __name__ == "__main__":
	"""
	Exit code 0    Все тесты успешно прошли
	Exit code 1    Некоторые тесты упали
	Exit code 2    Выполнение тестов было прервано пользователем или по таймауту
	Exit code 3    Во время выполнения тестов произошла внутренняя ошибка
	Exit code 4    Ошибка запуска из командной строки
	"""
	try:
		res = test_loader(sys.argv[1:])
	except Exception:
		print(traceback.format_exc(), file=sys.stderr)
		sys.exit(4)
	if res:
		count, status, test_table, len_sec = start()
		if status[TEST_STATUS.FAILED] or status[TEST_STATUS.FATAL]:
			sys.exit(1)
		elif status[TEST_STATUS.STOPPED] or status[TEST_STATUS.TIMEOUT]:
			sys.exit(2)
		elif status[TEST_STATUS.ERROR]:
			sys.exit(3)
		sys.exit(0)
	sys.exit(4)
