from typing import Callable, TypeVar
from typing import Literal, Union

E = TypeVar("E")
T = Union[frozenset[str], tuple[str], list[str], str]

TEST_STATUS = Literal[
	"UNKNOWN", "STARTED", "PASSED", "RETRO_PASSED", "WARNING", "FAILED", "FATAL"
	, "TIMEOUT", "ERROR", "XFAILED", "XPASSED", "SKIPPED", "STOPPED"
]

COMMAND_STATUS = Literal[
	"PASSED", "SKIPPED", "WARNING", "FAILED", "FATAL", "TIMEOUT", "ERROR"
	, "SKIP_TEST", "STOPPED"
]

RETRIES_MODE = Literal[
	"OFF", "ALL", "FLAKY", "CRITICAL", "BLOCKER"
]

SEVERITY = Literal[
	"TRIVIAL", "MINOR", "NORMAL", "CRITICAL", "BLOCKER"
]

LOAD_STRATEGY = Literal[
	"NORMAL", "EAGER", "NONE"
]

LOG_LEVEL = Literal[
	"OFF", "SEVERE", "WARNING", "INFO", "DEBUG", "ALL"
]

LOG_TYPES = Literal[
	"BROWSER", "CLIENT", "DRIVER", "PERFORMANCE", "PROFILER", "SERVER"
]

AUTH_METHOD = Literal[
	"OFF", "BASE", "DIGEST"
]

class ItemConfig:
	@classmethod
	def registrator(cls, *obj: ItemConfig):
		"""
		Регистрирует новое описание параметра конфигурации
		"""
	
	@classmethod
	def registr_data(cls) -> dict:
		"""
		Возвращает словарь описаний параметров конфигурации
		"""
	
	def __init__(self, name: str, data_type: E, default: E, description: str, serialize: Callable, desirialize: Callable, validator: Callable, read_only: bool, public: bool, key: str, full_key: str, help: str):
		pass
	
	@property
	def argument(self) -> (list, dict):
		"""
		Возвращает кортеж аргументов для ArgumentParser
		"""
	
	@property
	def help(self) -> str:
		"""
		Справочная информация
		"""
	
	@property
	def key(self) -> str:
		"""
		Возвращает сокращённый ключ для установки опции из командной строки
		"""
	
	@property
	def full_key(self) -> str:
		"""
		Возвращает сокращённый ключ для установки опции из командной строки
		"""
	
	@property
	def name(self) -> str:
		"""
		Наименование параметра конфигурации
		"""
	
	@property
	def description(self) -> str:
		"""
		Описание параметра конфигурации
		"""
	
	@property
	def data_type(self) -> E:
		"""
		Тип данных параметра конфигурации
		"""
	
	@property
	def default(self) -> E:
		"""
		Значение по умолчанию для параметра конфигурации
		"""
	
	@property
	def serialize(self) -> Callable:
		"""
		Сериализатор - унарная функция возвращающее сериализованное значение параметра
		"""
	
	@property
	def desirialize(self) -> Callable:
		"""
		Десерализатор - унарная функция восстанавливающая значения параметра из сериализвованного
		"""
	
	@property
	def validator(self) -> Callable:
		"""
		Валидатор - унарный предикат. True если значение параметра валидно, иначе False
		"""
	
	@property
	def read_only(self) -> bool:
		"""
		Нельзя менять значение параметра
		"""
	
	@property
	def public(self) -> bool:
		"""
		Отображать значение в словаре конфигурации
		"""

class CONFIG:
	VERSION: str
	BUILD_DATE: str
	DESCRIPTION: str
	ONLY_INFO: bool
	TEST_CONFIG_PATH: str
	TEST_CONFIG_NAME: str
	TEST_CONFIG_DIR: str
	EXT_DIR_PATH: str
	BROWSERS_DIR: str
	DOWNLOAD_DIR: str
	CACHE_DIR: str
	REPORT_DIR: str
	USER_PROFILE: bool
	REMOTE_EXECUTOR: str
	REMOTE_TIMEOUT: float
	LOG_LEVEL: LOG_LEVEL
	BASE_URL: str
	TAGS: T
	TEST_ID: T
	THREADS: int
	DELAY_THREADS: float
	SINGLE_THREADS: bool
	PAGE_SIZE:  Union[(int, int), str]
	REPORTS: T
	BROWSERS: T
	VACUUM: bool
	HEADLESS: bool
	INCOGNITO: bool
	TEST_FATALITY: bool
	TEST_REPEATED: int
	RETRIES_MODE: RETRIES_MODE
	RETRIES: int
	RETRIES_SLEEP: float
	PAGE_LOAD_STRATEGY: LOAD_STRATEGY
	PAGE_LOAD_TIMEOUT: float
	SCRIPT_TIMEOUT: float
	WAIT_TIMEOUT: float
	ENGINE_DELAY: float
	DEBUG: bool
	SILENTLY: bool
	LICENSE_KEYS: dict
	AUTH_METHOD: AUTH_METHOD
	AUTH_URL: str
	AUTH_USER: str
	AUTH_PASSWD: str
	PROXY: str
	TRIGGER: str
	BROWSER_LANG: str
