from engine import ReportData

class BaseReport:
	def start(self, report: ReportData):
		"""
		Запуск теста
		"""
	
	def start_step(self, report: ReportData):
		"""
		Переход на новый шаг
		"""
	
	def stop_step(self, report: ReportData):
		"""
		Завершение шага
		"""
	
	def sub_test(self, report: ReportData):
		"""
		Переход на новый субтест
		"""
	
	def message(self, report: ReportData):
		"""
		Печать сообщения
		"""
	
	def error(self, report: ReportData):
		"""
		Ошибка
		"""
	
	def warning(self, report: ReportData):
		"""
		Предупреждение
		"""
	
	def action(self, report: ReportData):
		"""
		Действие
		"""
	
	def test_error(self, report: ReportData):
		"""
		Ошибка теста FAIL
		"""
	
	def fatal_error(self, report: ReportData):
		"""
		Фатальная ошибка
		"""
	
	def timeout_error(self, report: ReportData):
		"""
		Превышение времени выполнения теста
		"""
	
	def scip_test(self, report: ReportData):
		"""
		Пропуск теста
		"""
	
	def stop_test(self, report: ReportData):
		"""
		Остановка теста
		"""
	
	def close(self):
		"""
		Закрытие репортёра
		"""
