from core_dsl import *
from types import NoneType, FunctionType
from typing import Union, TypeVar

from parameter import CONFIG

__all__ = [
	"CONFIG", "SCRIPT", "TEST", "SCOPE", "LOOP", "IF", "WHILE", "ARG", "DATA", "CLICK", "URL", "JS", "FATAL", "WIDTH", "FP", "SP"
	, "PAUSE", "KEY", "PRINT", "REFRESH", "BACK_PAGE", "FORWARD_PAGE", "CLEAR", "DATE", "HOVER", "CONFIG", "SCREENSHOT"
	, "GEOMETRY", "SCROLL", "NEW_WINDOW", "NEW_TAB", "WINDOW", "CLOSE", "STEP", "DOUBLE_CLICK", "COUNT", "DND", "NOT"
	, "TIME", "PAGE_URL", "PAGE_TITLE", "PAGE_SOURCE", "WARNING", "ASSERT", "HEIGHT", "MAXIMIZE", "MINIMIZE"
	, "POS_X", "POS_Y", "COOKIES", "DEL_COOKIE", "SET_COOKIE", "ONE", "ALL", "ANY", "NP", "STORAGE_KEYS"
	, "SKIP_TEST", "SKIP_STEP", "STOP_TEST", "GET_STORAGE", "SET_STORAGE", "DEL_STORAGE", "RIGHT_CLICK"
	, "UPLOAD", "CHECK_DOWNLOAD", "DATA_ATTR", "FRAME", "ANY_LIST", "ALL_LIST", "command"
]

E = TypeVar("E")
T = TypeVar("T")

WAIT      = Union[NoneType, float]
SELECTOR  = Union[str, FP, SP, NP, list[str]]
SELECTORS = Union[SELECTOR, list[SELECTOR]]

class URL(float):
	"""
	Переход на страницу, возвращает время загрузки страницы. Если адрес страницы не указан, то переход осуществляется на базовый URL (см. CONFIG.BASE_URL) 
	
	Аргументы:
	* url - Адрес страницы
	* timeout - тайм-аут загрузки страницы. *По умолчанию - CONFIG.WAIT_TIMEOUT*
	"""
	def __init__(self, url: str = "", timeout: float = 0.0):
		pass

class DATA:
	"""
	Вводит данные в элемент формы.
	
	Аргументы:
	* selector - Селектор элемента формы. Если нужно заполнить несколько элементов одними и теми же данными, то можно передать список селекторов.
	* data - строка для заполнения элемента формы
	* multi_selector - Если равен True, то селектор может указывать на несколько элементов. *По умолчанию - False*
	* clear - Если равен True, то перед заполнением поле формы будет очищено, иначе данные будут добавлены в конец существующей строки. *По умолчанию - True*
	* delay - Задержка ввода данных. *По умолчанию - 0.0*
	* press - Идентификатор клавиши которая будет нажата после завершения ввода данных (см. команду **KEY**)
	* click - Выполнять клик по элементу перед вводом данных
	* offset_x - Смещение точки клика по оси **X** относительно центра элемента.
	* offset_y - Смещение точки клика по оси **Y** относительно центра элемента.
	* execute  - Выполнять команду
	* timeout - Время явного ожидания элемента. *По умолчанию - CONFIG.WAIT_TIMEOUT*
	"""
	def __init__(
		self, selector: SELECTOR, data: T, multi_selector: bool = False
		, clear: bool = True, delay: float = 0.0, press: str = ""
		, click: bool = True, offset_x: float = 0.0, offset_y: float = 0.0
		, secret: bool=False, execute: bool=True, timeout: float = 0.0
	):
		pass

class DATA_ATTR:
	"""
	Изменяет значение атрибута у веб-элемента.
	
	Аргументы:
	* selector - Селектор элемента.
	* attr - Наименование атрибута.
	* value - Новое значение атрибута.
	* execute - Выполнять команду
	* timeout - Время явного ожидания элемента. *По умолчанию - CONFIG.WAIT_TIMEOUT*
	"""
	def __init__(self, selector: SELECTOR, attr: str, value: str, execute: bool=True, timeout: float = 0.0):
		pass

class KEY:
	"""
	Эмулирует нажатие клавиши на элементе. Команда предназначена только для передачи нажатия одной клавиши, для ввода текста используйте команду **DATA**. Если нужно передать нажатие нескольких клавиш, то для этого используйте список идентификаторов.
	
	Аргументы:
	* selector - Селектор элемента.
	* key - Идентификатор нажимаемой клавиши.
	* multi_selector - Если равен True, то селектор может указывать на несколько элементов. *По умолчанию - False*
	* execute - Выполнять команду
	* timeout - Время явного ожидания элемента. *По умолчанию - CONFIG.WAIT_TIMEOUT*
	"""
	F1         : str
	F2         : str
	F3         : str
	F4         : str
	F5         : str
	F6         : str
	F7         : str
	F8         : str
	F9         : str
	F10        : str
	F11        : str
	F12        : str
	NULL       : str
	CANCEL     : str
	HELP       : str
	BACK_SPACE : str
	TAB        : str
	CLEAR      : str
	RETURN     : str
	ENTER      : str
	SHIFT      : str
	CONTROL    : str
	ALT        : str
	PAUSE      : str
	ESCAPE     : str
	SPACE      : str
	PAGE_UP    : str
	PAGE_DOWN  : str
	END        : str
	HOME       : str
	LEFT       : str
	UP         : str
	RIGHT      : str
	DOWN       : str
	INSERT     : str
	DELETE     : str
	SEMICOLON  : str
	EQUALS     : str
	NUMPAD0    : str
	NUMPAD1    : str
	NUMPAD2    : str
	NUMPAD3    : str
	NUMPAD4    : str
	NUMPAD5    : str
	NUMPAD6    : str
	NUMPAD7    : str
	NUMPAD8    : str
	NUMPAD9    : str
	MULTIPLY   : str
	ADD        : str
	SEPARATOR  : str
	SUBTRACT   : str
	DECIMAL    : str
	DIVIDE     : str
	META       : str
	COMMAND    : str
	ZENKAKU_HANKAKU : str
	def __init__(self, selector: SELECTORS, key: str, multi_selector: bool = False, timeout: WAIT = 0.0):
		pass

class CLEAR:
	"""
	Очистка веб-элемента. Снимает выделение с элементов **checkbox** и **select**, очищает текстовые элементы.
	
	Аргументы:
	* selector - Селектор элемента. Если нужно очистить несколько элементов, то можно указать несколько селекторов.
	* multi_selector - Если равен True, то селектор может указывать на несколько элементов. *По умолчанию - False*
	* execute - Выполнять команду
	* timeout - Время явного ожидания элемента. *По умолчанию - CONFIG.WAIT_TIMEOUT*
	"""
	def __init__(self, selector: SELECTORS, multi_selector: bool = False, js: bool = False, execute: bool=True, timeout: WAIT = 0.0):
		pass

class CLICK:
	"""
	Эмулирует нажатие правой кнопки мыши на элементе. Если поле нажатие открывается новое окно или вкладка браузера, то автоматически переходим на неё.
	
	Аргументы:
	* selector - Селектор элемента. Если нужно эмулировать последовательность нажатий на нескольких элементах, то можно указать несколько селекторов.
	* offset_x - Смещение точки клика по оси **X** относительно центра элемента.
	* offset_y - Смещение точки клика по оси **Y** относительно центра элемента.
	* multi_selector - Если равен True, то селектор может указывать на несколько элементов. *По умолчанию - False*
	* js - Если равен True, то нажатие эмулируется через java script. *По умолчанию - False*
	* delay - Задержка перед началом клика.  *По умолчанию - 0.0*
	* execute - Выполнять команду
	* timeout - Время явного ожидания элемента. *По умолчанию - CONFIG.WAIT_TIMEOUT*
	"""
	def __init__(self, selector: SELECTORS, offset_x: float = 0.0, offset_y: float = 0.0, multi_selector: bool = False, js: bool = False, delay: float = 0.0, execute: bool=True, timeout: WAIT = 0.0):
		pass

class DOUBLE_CLICK:
	"""
	Эмулирует двойное нажатие правой кнопки мыши на элементе.
	
	Аргументы:
	* selector - Селектор элемента. Если нужно эмулировать последовательность нажатий на нескольких элементах, то можно указать несколько селекторов.
	* expression - Выражение, если оно вернёт *False*, то нажатие не будет эмулироваться. *По умолчанию - None*
	* execute - Выполнять команду
	* timeout - Время явного ожидания элемента. *По умолчанию - CONFIG.WAIT_TIMEOUT*
	"""
	def __init__(self, selector: SELECTORS, expression: E = None, execute: bool=True, timeout: WAIT = 0.0):
		pass

class RIGHT_CLICK:
	"""
	Эмулирует нажатие правой кнопки мыши на элементе. Может использоваться для вызова контекстное меню.
	
	Аргументы:
	* selector - Селектор элемента.
	* js - Если равен True, то нажатие эмулируется через javascript. *По умолчанию - False*
	* execute - Выполнять команду
	* timeout - Время явного ожидания элемента. *По умолчанию - CONFIG.WAIT_TIMEOUT*
	"""
	def __init__(self, selector: SELECTOR, js: bool = False, execute: bool=True, timeout: WAIT = 0.0):
		pass

class HOVER:
	"""
	Эмитирует перемещения курсора мыши на элемент.
	
	Аргументы:
	* selector - Селектор элемента.
	* click - Нажать ЛКМ после наведения курсора мыши на элемент.  *По умолчанию - False*
	* execute - Выполнять команду
	* timeout - Время явного ожидания элемента. *По умолчанию - CONFIG.WAIT_TIMEOUT*
	"""
	def __init__(self, selector: SELECTOR, click: bool = False, execute: bool=True, timeout: WAIT = 0.0):
		pass

class DND:
	"""
	Эмитирует перемещение веб элемента мышью. Элемент можно переместить на место другого элемента или на указанные координаты (относительно центра элемента).
	
	Аргументы:
	* Селектор 1 - Селектор перемещаемого элемента.
	* Селектор 2 - Селектор элемента на который перемещают элемент с селектором 2
	* offset_x - Смещение центра элемента по оси X.
	* offset_y - Смещение центра элемента по оси Y.
	* execute - Выполнять команду
	* timeout - Время явного ожидания элемента. *По умолчанию - CONFIG.WAIT_TIMEOUT*
	"""
	def __init__(self, selector1: SELECTOR, selector2: Union[NoneType, SELECTOR, int], offset_x: int = 0, offset_y: int = 0, execute: bool=True, timeout: WAIT = 0.0):
		pass

class JS:
	"""
	Выполнить js-скрипт асинхронно(ASYNC_JS) или синхронно (SYNC_JS). Возвращает результат работы скрипта.
	
	Аргументы:
	* js - код js скрипта.
	* args - аргументы передаваемые скрипту
	* sync - Синхронное (True) или асинхронное (False) выполнение скрипта. *По умолчанию - True*
	* execute - Выполнять команду
	* timeout - Именованный аргумент, устанавливает тайм-аут выполнения скриптов. *По умолчанию - CONFIG.WAIT_TIMEOUT*
	"""
	def __init__(self, js: str, args: tuple, sync: bool = True, execute: bool=True, timeout: float = 0.0):
		pass

class EP:
	"""
	Указатель на веб-элемент. Может использоваться с командами которым могут быть нужны элементы (например JS)
	
	Аргументы:
	* селектор - Селектор элемента до середины которого нужно прокрутить
	* timeout - Время явного ожидания элемента. *По умолчанию - CONFIG.WAIT_TIMEOUT*
	"""
	def __init__(self, selector: SELECTOR, timeout: WAIT = 0.0):
		pass

class REFRESH:
	"""
	Перезагружает текущую страницу.
	
	Аргументы:
	* timeout - тайм-аут загрузки страницы. *По умолчанию - CONFIG.WAIT_TIMEOUT*
	"""
	def __init__(self, timeout: float = 0.0):
		pass

class BACK_PAGE:
	"""
	Перемещаемся на один шаг **назад** по истории браузера
	
	Аргументы:
	* timeout - тайм-аут загрузки страницы. *По умолчанию - CONFIG.WAIT_TIMEOUT*
	"""
	def __init__(self, timeout: float = 0.0):
		pass

class FORWARD_PAGE:
	"""
	Перемещаемся на один шаг **вперёд** по истории браузера
	
	Аргументы:
	* timeout - тайм-аут загрузки страницы. *По умолчанию - CONFIG.WAIT_TIMEOUT*
	"""
	def __init__(self, timeout: float = 0.0):
		pass

class SCROLL:
	"""
	Прокрутка контента.
	
	Аргументы:
	* selector - Селектор элемента до середины которого нужно прокрутить
	* execute - Выполнять команду
	* timeout - Время явного ожидания элемента. *По умолчанию - CONFIG.WAIT_TIMEOUT*
	"""
	def __init__(self, selector: Union[SELECTOR, int, (int, int)], execute: bool=True, timeout: WAIT = 0.0):
		pass

########################## ОКНА / ВКЛАДКИ #######################
class NEW_WINDOW:
	"""
	Открывает новое окно браузера, после чего переходит на указанный адрес или на CONFIG.BASE_URL. Возвращает время загрузки страницы.
	
	Аргументы:
	* url - Адрес страницы. *Если не указан, то используется CONFIG.BASE_URL*
	* timeout - Время явного ожидания открытия окна. *По умолчанию - CONFIG.WAIT_TIMEOUT*
	"""
	def __init__(self, url: str = "", timeout: WAIT = 0.0):
		pass

class NEW_TAB:
	"""
	Открывает новую вкладку
	
	Аргументы:
	* url - Адрес страницы. *Если не указан, то используется CONFIG.BASE_URL*
	* timeout - Время явного ожидания открытия окна. *По умолчанию - CONFIG.WAIT_TIMEOUT*
	"""
	def __init__(self, url: str = "", timeout: WAIT = 0.0):
		pass

class WINDOW:
	"""
	Переключится на предыдущее окно/вкладку или на окно/вкладку с указанным индексом. Индексы присваиваются в порядке открытия окон или вкладок.
	Для обращения активным окнам с конца можно использовать отрицательные индексы. После переключения на окно оно изменяет свой индекс на последний.
	
	Аргументы:
	* index - порядковый номер окна/вкладки.  *По умолчанию: -2*
	"""
	def __init__(self, index: int = -2):
		pass

class CLOSE:
	"""
	Закрывает текущие окно/вкладку или на окно/вкладку с указанным индексом. Индексы присваиваются в порядке открытия окон или вкладок.
	Для обращения активным окнам с конца можно использовать отрицательные индексы. Единственное окно невозможно закрыть этой командой.
	
	Аргументы:
	* index - порядковый номер окна/вкладки.  *По умолчанию: -1*
	"""
	def __init__(self, index: int = -1):
		pass

class MAXIMIZE:
	"""
	Разворачивает окно
	"""

class MINIMIZE:
	"""
	Сворачивает окно
	"""

class POS_X(float):
	"""
	Возвращает X координату правого верхнего угла текущего окна браузера (относительно правого левого угла экрана) или элемента (относительно правого левого угла браузера).
	
	Аргументы:
	* selector - селектор элемента
	* timeout - Время явного ожидания элемента. По умолчанию - CONFIG.WAIT_TIMEOUT
	"""
	def __init__(self, *selector: SELECTORS, timeout: WAIT = 0.0):
		pass

class POS_Y(float):
	"""
	Возвращает Y координату правого верхнего угла текущего окна браузера (относительно правого левого угла экрана) или элемента (относительно правого левого угла браузера).
	
	Аргументы:
	* selector - селектор элемента
	* timeout - Время явного ожидания элемента. *По умолчанию - CONFIG.WAIT_TIMEOUT*
	"""
	def __init__(self, *selector: SELECTORS, timeout: WAIT = 0.0):
		pass

class WIDTH(float):
	"""
	Возвращает ширину окна браузера или элемента
	
	Аргументы:
	* селектор - селектор элемента
	* timeout - Время явного ожидания элемента. По умолчанию - CONFIG.WAIT_TIMEOUT
	"""
	def __init__(self, selector: SELECTORS, scroll: bool = False, timeout: WAIT = 0.0):
		pass

class HEIGHT(float):
	"""
	Возвращает высоту окна браузера или элемента
	
	Аргументы:
	* селектор - селектор элемента
	* timeout - Время явного ожидания элемента. По умолчанию - CONFIG.WAIT_TIMEOUT
	"""
	def __init__(self, *selector: SELECTORS, scroll: bool = False, timeout: WAIT = 0.0):
		pass

class GEOMETRY:
	"""
	Изменяет геометрию окна браузера
	
	Аргументы:
	* x - X-координата верхнего левого угла браузера. *По умолчанию - POS_X*
	* y - Y-координата верхнего левого угла браузера. *По умолчанию - POS_Y*
	* width - ширина окна браузера (не может быть меньше 516). *По умолчанию - WIDTH*
	* height - высота окна браузера (не может быть меньше 134). *По умолчанию - HEIGHT*
	"""
	def __init__(self, x: Union[int, NoneType] = None, y: Union[int, NoneType] = None, width: Union[int, NoneType] = None, height: Union[int, NoneType] = None):
		pass

class FRAME:
	"""
	Команда переключает текущий контекст вебдрайвера на фрейм указанный в селекторе.
	Если используется несколько вложенных фреймов то необходимо передать их селекторы в соответствующем порядке.
	Если селектор не указан, то контекст переключается на основную страницу.
	
	Команда полезна если необходимо активно работать с несколькими элементами внутри фрейма.
	Получить доступ к отдельному элементу в фрейме удобнее при помощи селектора **FP** (см. раздел [Основы мета-языка](/doc-base)).
	"""
	def __init__(self, *selector: SELECTORS, reset: bool = False):
		pass

class COUNT(int):
	"""
	Подсчёт количества элементов.
	
	Аргументы:
	* selector - Селектор веб-элемента.
	* displayed - Если установлен в True, то ждём отображения элементов. *По умолчанию - True*
	* timeout - Время явного ожидания исчезновения элемента. *По умолчанию - CONFIG.WAIT_TIMEOUT*
	"""
	def __init__(self, selector: SELECTOR, displayed: bool = True, timeout: float = 0.0):
		pass

class SCREENSHOT:
	"""
	Добавляет список скриншотов в отсчёт. Если селекторы не указаны, то добавляет скриншот всей страницы.
	Не обязательный параметр **css** позволяет добавить таблицу стилей перед созданием скриншота.
	
	Аргументы:
	* selector - Селектор элемента с которого будет сделан скриншот. Можно указать более одного селектора.
	* css - таблица стилей которая будет применена ко всей страницы перед созданием скриншота.
	* timeout - Время явного ожидания исчезновения элемента. По умолчанию - CONFIG.WAIT_TIMEOUT
	"""
	def __init__(self, selector: SELECTOR, css: str = "", timeout: float = 0.0):
		pass

########################### Константы ###########################
class TIME(str):
	"""
	Константа содержащая текущее время представленное в соответствии с в заданным форматом.
	Если формат не задан, то используется - "hh:mm:ss.ms"
	"""
	def __init__(self, form: str=""):
		pass

class DATE(str):
	"""
	Константа содержащая текущую дату представленную в соответствии с в заданным форматом.
	Если формат не задан, то используется - "YYYY-MM-DD"
	"""
	def __init__(self, form: str=""):
		pass

class PAGE_URL(str):
	"""
	Константа содержащая текст ссылки на текущую страницу.
	"""

class PAGE_TITLE(str):
	"""
	Константа содержащая заголовок страницы.
	"""

class THREAD_NUMBER(str):
	"""
	Константа содержащая номер текущего потока
	"""

class PAGE_SOURCE(str):
	"""
	Константа содержащая HTML код страницы.
	"""

####################### COOKIES-STORAGE #########################
class DEL_COOKIE:
	"""
	Удаляет cookies с идентификатором name, если он не указан, то удаляет все cookies.
	
	Аргументы:
	* name  - Имя cookie
	"""
	def __init__(self, name: Union[str, list[str]]):
		pass

class SET_COOKIE:
	"""
	Добавляет cookies.
	
	Аргументы:
	* name  - Имя cookie
	* value - Значение cookie
	* property_dict - Словарь свойств
	"""
	def __init__(self, name: str, value: str, property_dict: Union[dict, NoneType] = None):
		pass

class COOKIES:
	"""
	Константа предоставляющая доступ ко всем cookie на текущей странице.
	"""
	def __init__(self, name: str, arg: str):
		pass

class GET_STORAGE:
	"""
	Возвращает значение из localStorage
	
	Аргументы:
	* key  - Идентификатор данных
	"""
	def __init__(self, key: str):
		pass

class SET_STORAGE:
	"""
	Устанавливает значение в localStorage
	
	Аргументы:
	* key  - Идентификатор данных
	* value - Данные
	"""
	def __init__(self, key: str, value: str):
		pass

class DEL_STORAGE:
	"""
	Возвращает значение из localStorage
	
	Аргументы:
	* key  - Идентификатор данных
	"""
	def __init__(self, key: Union[str, list[str]]):
		pass

class STORAGE_KEYS:
	"""
	Список ключей localStorage
	"""

############################# Файлы #############################
class UPLOAD:
	"""
	Загрузка файла на сайт.
	
	Аргументы:
	* селектор - Селектор элемента загрузки. Должен иметь тег **input** и атрибут **file**
	* path - Путь к загружаемому файлу
	* timeout - Время явного ожидания. *По умолчанию - CONFIG.WAIT_TIMEOUT*
	
	Если в аргументе **path** передан относительный путь, то поиск файла будет производится относительно каталога тестового набора т.е. **CONFIG.TEST_CASE_PATH**.
	"""
	def __init__(self, selector: SELECTOR, path: str, timeout: WAIT = 0.0):
		pass

class CHECK_DOWNLOAD:
	"""
	Проверяет скаченный файл.
	
	Аргументы:
	* name - имя файла
	* quality - Проверяемая величина.
	* timeout - Максимальное время ожидания скачивания файла. *По умолчанию - 30 сек.*
	
	В аргумент **quality** можно передать значения следующих типов:
	* Строка, её значение должно быть равным md5 хешу файла.
	* Целое положительное число, равное размеру файла в байтах. 
	* Унарная функция. Ей передаётся путь к скаченному файлу, она должны вернуть True если файл валиден, иначе False.
	"""
	def __init__(self, name: str, quality: Union[NoneType, str, int, FunctionType] = None, timeout: WAIT = 30.0):
		pass

class Expression:
	"""
	Перегруженные операторы должны возвращать ExpAll
	"""
	def __add__(self, obj: T) -> Expression:
		pass
	
	__radd__ = __and__ = __rand__ = __sub__ = __rsub__ = __mul__ = __rmul__ = __truediv__ = __rtruediv__ = __floordiv__ \
		= __rfloordiv__ = __mod__ = __rmod__ = __pow__ = __rpow__ = __or__ = __ror__ = __invert__ = __eq__ = __ne__ \
		= __gt__= __lt__ = __ge__ = __le__ = __rshift__ = __rrshift__ = __lshift__ = __rlshift__ = __matmul__ = __getitem__ \
		= __round__ = __trunc__ = __floor__ = __ceil__ = Expression.__add__

class ONE(Expression, ARGUMENT):
	"""
	**Квантор единственности**. Если селектор будет указывать более чем на один элемент или элементов вообще не будет обнаружено, то попытка выполнения квантора завершится с ошибкой.
	В противном случае квантор вернёт свойство элемента на который указывает селектор.
	
	Какое именно свойство нужно вернуть указывается в необязательном атрибуте **properties**. Если атрибут не задан то:
	
	* для элементов **input, textarea, select, progress и param** возвращается значение свойства **value**
	* для элемента **option** возвращается значение свойства **selected**
	* для всех других элементов значение свойства **textContent**
	
	properties так же может ссылаться на css свойства элемента или на его атрибуты.
	Для этого нужно указать его префикс **css::** или **attr::** соответственно.
	
	Кроме properties квантор может принимать следующие параметры:
	
	* displayed - Если равен True, то ждём отображения элемента на страницы. *По умолчанию - False*
	* strip - Если равен True, удаляются все пробельные символы в начале и конце возвращаемой строки. *По умолчанию - True*
	* timeout - Время явного ожидания элемента. *По умолчанию - CONFIG.WAIT_TIMEOUT*
	"""
	def __init__(self, selector: SELECTOR, properties: str = "", displayed: bool = False, strip: bool = True, timeout: WAIT = 0.0):
		pass

class NOT:
	"""
	Вызывает ошибку если элемент на который указывает селектор присутствует на странице. Команда проверяет именно отсутствие элемента в DOM, а не только его недоступность пользователю.
	Если указан не только селектор, но ещё и атрибут, то команда проверяет исчезновение указанного атрибута у элемента.
	
	Аргументы:
	* селектор - Селектор веб-элемента. Если нужно проверить несколько элементов, то можно передать список селекторов.
	* атрибут - Наименование проверяемого атрибута.
	* timeout - Время явного ожидания исчезновения элемента. *По умолчанию - CONFIG.WAIT_TIMEOUT*
	"""
	def __init__(self, selector: SELECTORS, attr: str = "", no_displayed: bool=False, timeout: WAIT = 0.0):
		pass

class ALL(Expression, ARGUMENT):
	"""
	**Квантор всеобщности** Этот квантор возвращает не одно, а список свойств. Принимает истину когда все его значения истинны.
	
	Какое именно свойство нужно вернуть указывается в необязательном атрибуте **properties**. Если атрибут не задан то:
	
	* для элементов **input, textarea, select, progress и param** возвращается значение свойства **value**
	* для элемента **option** возвращается значение свойства **selected**
	* для всех других элементов значение свойства **textContent**
	
	properties так же может ссылаться на css свойства элемента или на его атрибуты.
	Для этого нужно указать его префикс **css::** или **attr::** соответственно.
	
	Кроме properties квантор может принимать следующие параметры:
	
	* displayed - Если равен True, то ждём отображения элемента на страницы. *По умолчанию - False*
	* strip - Если равен True, удаляются все пробельные символы в начале и конце возвращаемой строки. *По умолчанию - True*
	* timeout - Время явного ожидания элемента. *По умолчанию - CONFIG.WAIT_TIMEOUT*
	"""
	def __init__(self, selector: SELECTOR, properties: str = "", displayed: bool = False, strip: bool = True, unique: bool = False, timeout: WAIT = 0.0):
		pass

class ANY(Expression, ARGUMENT):
	"""
	**Квантор существования**. Этот квантор возвращает не одно, а список свойств. Принимает истину когда любое из его значений истинно, а не все.
	
	Какое именно свойство нужно вернуть указывается в необязательном атрибуте **properties**. Если атрибут не задан то:
	
	* для элементов **input, textarea, select, progress и param** возвращается значение свойства **value**
	* для элемента **option** возвращается значение свойства **selected**
	* для всех других элементов значение свойства **textContent**
	
	properties так же может ссылаться на css свойства элемента или на его атрибуты.
	Для этого нужно указать его префикс **css::** или **attr::** соответственно.
	
	Кроме properties квантор может принимать следующие параметры:
	
	* displayed - Если равен True, то ждём отображения элемента на страницы. *По умолчанию - False*
	* strip - Если равен True, удаляются все пробельные символы в начале и конце возвращаемой строки. *По умолчанию - True*
	* timeout - Время явного ожидания элемента. *По умолчанию - CONFIG.WAIT_TIMEOUT*
	"""
	def __init__(self, selector: SELECTOR, properties: str = "", displayed: bool = False, strip: bool = True, unique: bool = False, timeout: WAIT = 0.0):
		pass

class ANY_LIST:
	def __init__(self, *data: T):
		pass

class ALL_LIST:
	def __init__(self, *data: T):
		pass
