
class BaseExit(SystemExit):
	pass

class ServerError(BaseExit):
	"""
	Ошибки инфраструктуры
	"""

class BrowserError(BaseExit):
	"""
	Не удалось создать объект браузера
	"""

class BrowserVersionError(BrowserError):
	"""
	Не верно указана версия браузера
	"""

class AuthError(BrowserError):
	"""
	Ошибка авторизации
	"""

class PathError(BaseExit):
	"""
	Ошибка пути к файлу
	"""

class TestConfigError(BaseExit):
	"""
	Ошибки тестовой конфигурации
	"""

class InstallError(BaseExit):
	"""
	Ошибка установки драйвера или браузера
	"""

class InstallExistsError(InstallError):
	"""
	Устанавливаемый файл отсутствует
	"""

class EngineError(BaseExit):
	"""
	Ошибка интерпретатора
	"""

class ParameterError(BaseExit):
	"""
	Не верный параметр
	"""

class ScopeError(BaseExit):
	"""
	Ошибка скопа
	"""

##################################################################
class TestError(Exception):
	"""
	Базовый класс ошибок
	"""

class NetError(TestError):
	"""
	Ошибка взаимодейсвия с сетью
	"""

class FatalError(TestError):
	"""
	Ошибка завершающая теста
	"""

class Status500Error(FatalError):
	"""
	Ошибка сервера
	"""

class Status400Error(FatalError):
	"""
	Страница не найдена
	"""

class LicenseError(FatalError):
	"""
	Нарушение лицензии
	"""

##################################################################
class FailedError(TestError):
	"""
	Не фатальная ошибка
	"""

class ExpError(FailedError):
	"""
	Ошибка выражений
	"""

class WaitError(FailedError):
	"""
	Ошибка отключенного ожидания для выражений
	"""

class SelectorError(FailedError):
	"""
	Ошибки поиска элемента
	"""

class NothingError(FailedError):
	"""
	Пропуск действия
	"""

class TriggerNothingError(NotImplementedError):
	"""
	Ошибки триггера
	"""
