
from browsers import Browser
from core_dsl import BaseDSL

class BaseTrigger:
	def setup(self):
		"""
		Срабатывает перед запуском тестовой конфигурации
		"""
	
	def setup_test(self, browser: Browser, test_id: str, test_scope: dict, test_args: dict):
		"""
		Срабатывает перед запуском теста
		"""
	
	def teardown_test(self, browser: Browser, test_id: str, test_scope: dict, test_args: dict):
		"""
		Срабатывает после окончания работы теста
		"""
	
	def setup_step(self, browser: Browser, step_id: str, test_scope: dict, step_args: dict):
		"""
		Срабатывает перед переходом на новый шаг теста
		"""
	
	def teardown_step(self, browser: Browser, step_id: str, test_scope: dict, step_args: dict):
		"""
		Срабатывает после окончания работы шага теста
		"""
	
	def setup_script(self, browser: Browser, script_id: str, test_scope: dict, script_args: dict):
		"""
		Срабатывает перед началом сценария
		"""
	
	def teardown_script(self, browser: Browser, script_id: str, test_scope: dict, script_args: dict):
		"""
		Срабатывает после окончания сценария
		"""
	
	def setup_command(self, browser: Browser, command: BaseDSL, test_scope: dict):
		"""
		Срабатывает перед выполнением комманды
		"""
	
	def teardown_command(self, browser: Browser, command: BaseDSL, test_scope: dict):
		"""
		Срабатывает после выполнением комманды
		"""
	
	def close(self):
		"""
		Срабатывает после окончания работы тестового пакета
		"""
