from typing import Callable, TypeVar

T = TypeVar("T")

def time_format(timestamp: float, nsec: int) -> str:
	"""
	Возвращает строку времени формата mm.ssssssss
	"""

def get_platform() -> str:
	"""
	Возвращает код текущей платформы
	"""

def get_api_data(endpoint: str, timeout: int, headers: dict) -> bytes:
	"""
	Возвращает данные из API
	"""

def get_api_json(endpoint: str, timeout: int, headers: dict) -> dict:
	"""
	Возвращает данные из API в виде словаря
	"""

def download(url: str, path: str, name: str, progress: Callable, timeout: int):
	"""
	Скачивает файл. Если файл скачен возвращает True, иначе False
	"""

def print_progress(total: int, value: int, width: int):
	"""
	Печатаем Индикатор выполнения
	"""

def get_zip_files(zip_archive: str):
	"""
	Возвращает список имён файлов в zip архиве
	"""

def copy_to_zip(zip_archive: str, file_name: str, path: str):
	"""
	Извлекает файл из zip архива в указанный путь
	"""

def is_collect(data: T) -> bool:
	"""
	Возвращает True если data является коллекцией
	"""

def rMkDir(path: str) -> str:
	"""
	создание вложенных каталогов
	"""

def rmPath(path: str):
	"""
	Рекурсивное удаление файлов и каталогов
	"""

def x_path(path: str):
	"""
	Проверяет доступ к path на выполнение, если есго нет, то пытается установить
	"""

def diff_path(path1: str, path2: str):
	"""
	Возвращает разницу между путями path1 и path2
	"""

def get_exec_prog(prog: str) -> str:
	"""
	Проверяет наличие программ в системе
	возвращает путь к исполняемому файлу
	"""

class Version:
	"""
	Класс для объекта "версия" позволяет приводить правильное сравнение версий вида xxx.yy.zzz....
	"""
	def __init__(self, version: str):
		pass

def linux_browser_version(binary_path: str) -> str:
	"""
	Запуск броузера с параметрами, возвращает вывод командной строки
	"""

def mac_browser_version(app_path: str) -> str:
	"""
	Возвращает версию программы из свойства файла
	"""

def win_browser_version(exe_path: str) -> str:
	"""
	Возвращает версию программы и путь к ней
	В начале exe_path допускается указывать ключи из env
	"""

def md5File(path: str) -> str:
	"""
	Вычисление контрольной суммы файла
	"""

def reduce(call: Callable, data: T, init: T):
	"""
	В python 3.x был сломан reduce, мы его починили
	"""

def concat(s: T) -> T:
	"""
	Канкатенатор:
	>>> concat([(1,2,3), (4,5)])
	(1, 2, 3, 4, 5)
	"""

def pzUnpack(data: list, structure: list) -> list:
	"""
	Безопасная распаковка
	"""

def typOrPz(typ: T, value: T, pz: T):
	"""
	Пытается привести значение value к типу typ, если возникает исключение TypeError, то возвращает pz
	"""

def get_arity(call: Callable) -> int:
	"""
	Возвращает арность функции
	"""

def normalize_url(url: str, base: str) -> str:
	"""
	Нормализует относительный URL
	"""
