# Meta Test

## Платформа QA тестирования
[https://meta_test.kybyc.xyz/](https://meta_test.kybyc.xyz/)

Платформа предназначена для создания и запуска UI-тестов для автоматизированной проверки веб-приложений людьми без навыков программирования. Для описания тестов используется специальный декларативный "метаязык", что позволяет избавится от сложных для понимания концепций по подобии Page Object Model. Но тем не менее метаязык можно использовать вместе с обычным кодом на языке python что например позволяет более гибко работать с источниками тестовых данных, отправлять API запросы и даже создавать новые команды для метаязыка.
**[Примеры тестовых конфигураций](https://gitflic.ru/project/meta-test/examples)**

В настоящее время платформа представляет из себя:
* метаязык для описания тестовых сценариев со средой выполнения
* систему многопоточного запуска тестов
* встроенные автоматические ожидания
* механизм автоматической загрузки драйверов и браузеров
* систему триггеров
* средства интеграции с инструментами построения отчётов
* систему расширений

## Системные требования

Платформа предназначена для использования на многоядерных процессорах с архитектурой **x86-64**. Для запуска рекомендуется использовать операционную систему Debian Linux 12, но тем не менее платформа  работает и на других современных дистрибутивах. Так же возможна работа и на операционных системах Windows 11 и iMac 15.

Рекомендуемые системные требования:
* ОС: Debian Linux 13 AMD64/x86–64
* Процессор: Intel Core i5-2500K или выше
* Оперативная память: 2 ГиБ
* Место на диске: 1.0 ГиБ

## Дистрибутив

Платформа не требует отдельной установки и может использоваться стразу после распаковки дистрибутивного архива. Для её запуска нужно из командной строки перейти в каталог платформы и выполнить исполняемый файл **metatest** (или **metatest.bat** в случае с windows) передав ему имя (если конфигурация находится в каталоге **tests**) или путь к каталогу с конфигурацией тестов. *Подробное описание параметров запуска находится в разделе документации [Параметры среды](https://metatest.kybyc.xyz/doc-config)*

Переходим в каталог с платформой и запускаем:
```bash
$ ./metatest тестовая_конфигурация [ параметры ] { -P ПАРАМЕТР=значение} { -F ФЛАГ } { -T ФЛАГ }
```

В некоторых случаях наиболее актуальна глобальная установка платформы. Для неё достаточно распаковать каталог дистрибутива в любое подходящее мести и создать символьную ссылка на исполняемый файл:

Пример глобальной установки:
```bash
# tar -xf meta_test-1.0-linux-x86_64-debian_12.tar.gz -C /opt
# ln -s /opt/meta_test/metatest /usr/local/bin/metatest
```

Для установки дополнительных python - библиотек нужно использовать **pip3** из подкаталога **python/bin/** находящегося в каталоге платформы.

Пример:
```
$ /opt/meta_test/metatest/python/bin/pip3 install faker
```

Более подробную информацию об использовании платформы смотрите в разделе [Быстрый старт](https://metatest.kybyc.xyz/doc-start)

## Состав дистрибутива

| Каталог      | Описание                                          |
|--------------|---------------------------------------------------|
| metatest     | Исполняемый файл для запуска платформы            |
| tests/       | Каталог для тестовых конфигураций                 |
| reports/     | Каталог для хранения результатов отчётов          |
| python/      | Локальное python-окружение                        |
| meta_test/   | Платформа                                         |
| extensions/  | Каталог расширений                                |
| browsers/    | каталог браузеров                                 |
